"use strict";
(self["webpackChunkpixfort_core"] = self["webpackChunkpixfort_core"] || []).push([["dev_builder_components_fields_radio_js"],{

/***/ "./dev/builder/components/fields/radio.js":
/*!************************************************!*\
  !*** ./dev/builder/components/fields/radio.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
    value: true
}));

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var _react2 = _interopRequireDefault(_react);

var _react3 = __webpack_require__(/*! @headlessui/react */ "./node_modules/@headlessui/react/dist/index.cjs");

var _help = __webpack_require__(/*! ../common/help */ "./dev/builder/components/common/help.js");

var _help2 = _interopRequireDefault(_help);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RadioInput = function (_React$Component) {
    _inherits(RadioInput, _React$Component);

    function RadioInput(props) {
        _classCallCheck(this, RadioInput);

        var _this = _possibleConstructorReturn(this, (RadioInput.__proto__ || Object.getPrototypeOf(RadioInput)).call(this, props));

        _initialiseProps.call(_this);

        var value = '';
        var options = [];
        var checkPosition = { right: '0.375rem' };
        if (_this.props.options) {
            options = structuredClone(_this.props.options);
        }
        if (_this.props.value && _this.props.value !== '') {
            value = _this.props.value;
        } else {
            if (_this.props.default) {
                value = _this.props.default;
            }
        }
        if (_this.props.checkPosition && _this.props.checkPosition === 'left') {
            checkPosition = { left: '0.375rem' };
        }
        _this.state = {
            value: value,
            options: options,
            checkPosition: checkPosition
        };

        _this.props.onChange({
            value: value,
            id: _this.props.id
        });
        return _this;
    }

    _createClass(RadioInput, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            return _react2.default.createElement(
                'div',
                { className: 'pix-opt-radio-input-field mx-6 pt-6 pb-4 ' + (this.props.hideBorderBottom === true ? '' : 'border-b border-gray-100') + ' ' + (this.props.showBorderTop === true ? 'border-t border-gray-100' : '') + ' dark:border-gray-700 ' },
                _react2.default.createElement(
                    'div',
                    { className: 'pr-2 pb-2 text-sm' },
                    _react2.default.createElement(
                        'label',
                        { className: 'mb-0 flex items-center cursor-auto' },
                        _react2.default.createElement(
                            'span',
                            { className: 'font-semibold text-gray-900 dark:text-white' },
                            this.props.label
                        ),
                        this.props.tooltipImage || this.props.tooltipText ? _react2.default.createElement(_help2.default, { tooltipText: this.props.tooltipText, tooltipImage: this.props.tooltipImage, type: 'default' }) : null
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'mt-1 mb-2 text-gray-500' },
                        this.props.description
                    )
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'w-full' },
                    _react2.default.createElement(
                        'div',
                        { className: 'w-full text-left' },
                        _react2.default.createElement(
                            _react3.RadioGroup,
                            { value: this.state.value, onChange: this.radioChange },
                            _react2.default.createElement(
                                _react3.RadioGroup.Label,
                                { className: 'sr-only' },
                                'Server size'
                            ),
                            _react2.default.createElement(
                                'div',
                                { className: '' },
                                this.state.options && this.state.options.map(function (option) {
                                    return _react2.default.createElement(
                                        _react3.RadioGroup.Option,
                                        {
                                            key: option.value,
                                            value: option.value,
                                            className: function className(_ref) {
                                                var active = _ref.active,
                                                    checked = _ref.checked;
                                                return 'border border-gray-200 dark:border-gray-600 ring-4 bg-white dark:bg-gray-700 ' + (active ? '' : '') + '\n                  ' + (checked ? 'bg-opacity-95 text-white ring-3 ring-primary border-transparent' : 'ring-transparent') + '\n                    relative overflow-hidden inline-flex cursor-pointer rounded-lg mr-4 shadow-sm my-2 focus:outline-none transition-all ease-in-out duration-100';
                                            }
                                        },
                                        function (_ref2) {
                                            var active = _ref2.active,
                                                checked = _ref2.checked;
                                            return _react2.default.createElement(
                                                'div',
                                                { className: 'inline-flex items-center' },
                                                _react2.default.createElement(
                                                    'div',
                                                    { className: 'inline-flex flex-col text-xs items-center overflow-hidden' },
                                                    _react2.default.createElement(
                                                        _react3.RadioGroup.Label,
                                                        { as: 'div', className: (checked ? 'text-gray-900' : 'text-gray-500') + ' dark:hue-rotate-180 dark:brightness-[0.9] dark:grayscale-[0.7] dark:contrast-[1.1]' },
                                                        option.image && _react2.default.createElement('img', { className: 'max-w-[100px] min-w-[60px] block dark:invert-[.85] dark:sepia', src: option.image })
                                                    ),
                                                    option.name && option.name !== '' && _react2.default.createElement(
                                                        _react3.RadioGroup.Description,
                                                        { as: 'span', className: 'inline p-1 border-t w-full text-center border-gray-200 dark:border-gray-600 ' + (checked ? 'text-gray-900 dark:text-white font-semibold' : 'text-gray-500 dark:text-gray-400') },
                                                        _react2.default.createElement(
                                                            'div',
                                                            { className: '' },
                                                            option.name
                                                        ),
                                                        checked && _react2.default.createElement(
                                                            'svg',
                                                            { className: 'shrink-0 h-5 w-5 text-primary absolute top-1.5', style: _this2.state.checkPosition, viewBox: '0 0 24 24', fill: 'none' },
                                                            _react2.default.createElement('circle', { cx: 12, cy: 12, r: 12, fill: 'currentcolor', opacity: '1' }),
                                                            _react2.default.createElement('path', { d: 'M7 13l3 3 7-7', stroke: '#fff', strokeWidth: 2, strokeLinecap: 'round', strokeLinejoin: 'round' })
                                                        )
                                                    )
                                                )
                                            );
                                        }
                                    );
                                })
                            )
                        )
                    ),
                    _react2.default.createElement('input', { type: 'hidden', onChange: this.handleInputChange, value: this.state.value, name: 'field-' + this.props.id })
                )
            );
        }
    }]);

    return RadioInput;
}(_react2.default.Component);

RadioInput.defaultProps = {
    label: 'Text Input',
    options: [],
    value: '',
    onChange: function onChange() {}
};

var _initialiseProps = function _initialiseProps() {
    var _this3 = this;

    this.handleInputChange = function (e) {
        var newValue = e.target.value;
        _this3.setState({
            value: newValue
        });
        _this3.props.onChange({
            value: newValue,
            id: _this3.props.id
        });
    };

    this.radioChange = function (value) {
        _this3.setState({
            value: value
        });
        _this3.props.onChange({
            value: value,
            id: _this3.props.id
        });
    };
};

exports["default"] = RadioInput;

/***/ })

}]);
//# sourceMappingURL=dev_builder_components_fields_radio_js.bundle.js.map