<?php

/**
 * BWS Recaptcha for Elementor Pro
 *
 * @since 1.65
 */
namespace ElementorPro\Modules\Forms;

use Elementor\Core\Experiments\Manager;
use ElementorPro\Base\Module_Base;
use ElementorPro\Modules\Forms\Classes;
use ElementorPro\Modules\Forms\Controls\Fields_Map;
use ElementorPro\Modules\Forms\Registrars\Form_Actions_Registrar;
use ElementorPro\Modules\Forms\Registrars\Form_Fields_Registrar;
use ElementorPro\Modules\Forms\Controls\Fields_Repeater;
use ElementorPro\Modules\Forms\Submissions\Component as Form_Submissions_Component;
use ElementorPro\Plugin;

class Elementor_Gglcptch {

	/**
	 * Get action name.
	 *
	 * Retrieve ping action name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string
	 */
	public function get_name() {
		return 'gglcptch';
	}

	/**
	 * Get action label.
	 *
	 * Retrieve ping action label.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string
	 */
	public function get_label() {
		return esc_html( 'BWS reCAPTCHA' );
	}


	protected function get_control_id( $control_id ) {
			return $control_id;
	}

	public static function is_enabled() {
		$is_user_logged_in = is_user_logged_in();
		if ( gglcptch_is_recaptcha_required( 'elementor_contact_form', $is_user_logged_in ) ) {
				return true;
		}
		if ( gglcptch_is_hidden_for_role() ) {
			return true;
		}
		return false;
	}

	/**
	 * Register action controls.
	 *
	 * Ping action has no input fields to the form widget.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param \Elementor\Widget_Base $widget
	 */
	public function register_settings_section( $widget ) {}

	/**
	 * On export.
	 *
	 * Ping action has no fields to clear when exporting.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param array $element
	 */
	public function on_export( $element ) {}

	/**
	 * @param Form_Record  $record
	 * @param Ajax_Handler $ajax_handler
	 */
	public function validation( $record, $ajax_handler ) {
		$fields = $record->get_field( [
				'type' => 'gglcptch',
		] );
		if ( empty( $fields ) ) {
				return;
		}


		$field = current( $fields );
		unset( $ajax_handler->errors[ $field['id'] ] );
		if ( gglcptch_is_hidden_for_role() ) {
			$ajax_handler->set_success( true );
		} else {      
			// validation
			$gglcptch_check = gglcptch_check( 'elementor_contact_form' );
			if ( ! $gglcptch_check['response'] ) {
					$message = $gglcptch_check['errors']->get_error_messages()[0];
					$ajax_handler->add_error( $field['id'], $message );
					$ajax_handler->messages['error'][] = $message;
			} else {
				if ( empty( $ajax_handler->errors ) ) {
					$ajax_handler->set_success( true );
				}
			}
		}

		// If success - remove the field form list (don't send it in emails and etc )
		$record->remove_field( $field['id'] );
	}

	public function render_field() {
		echo gglcptch_display();
	}

	public function add_field_type( $field_types ) {
		$field_types['gglcptch'] = 'BWS reCAPTCHA';

		return $field_types;
	}

	public function filter_field_item( $item ) {
		if ( 'gglcptch' == $item['field_type'] ) {
				$item['field_label'] = false;
		}
		return $item;
	}

	public function __construct() {
		if ( static::is_enabled() ) {
			add_filter( 'elementor_pro/forms/field_types', [ $this, 'add_field_type' ] );
			add_action( 'elementor_pro/forms/render_field/gglcptch', [ $this, 'render_field' ] );
			add_filter( 'elementor_pro/forms/render/item', [ $this, 'filter_field_item' ] );  
			add_action( 'elementor_pro/forms/validation', [ $this, 'validation' ], 10, 2 );
		}
	}
}

if ( Elementor_Gglcptch::is_enabled() ) {
	$request_actions = array();
	if ( isset( $_REQUEST['actions'] ) ) {
		$request_actions = json_decode( stripslashes( $_REQUEST['actions'] ), true );
	}
	if ( empty( $request_actions ) || ! isset( $request_actions['integrations_mailchimp'] ) ) {
    $all_plugins = get_plugins();
		if ( version_compare( $all_plugins['elementor-pro/elementor-pro.php']['Version'], '3.5.0', '<=' ) && class_exists( 'Module_Base' ) ) {
			class Module extends Module_Base {
				/**
				 * @var Form_Actions_Registrar
				 */
				public $actions_registrar;

				/**
				 * @var Form_Fields_Registrar
				 */
				public $fields_registrar;

				public function get_name() {
						return 'forms';
				}

				public function get_widgets() {
						return [
								'Form',
								'Login',
						];
				}

				public function localize_settings( $settings ) {
						$settings = array_replace_recursive( $settings, [
								'i18n' => [
										'x_field' => esc_html__( '%s Field', 'google-captcha-pro' ),
								],
						] );

						return $settings;
				}

				public static function find_element_recursive( $elements, $form_id ) {
						foreach ( $elements as $element ) {
								if ( $form_id === $element['id'] ) {
										return $element;
								}

								if ( ! empty( $element['elements'] ) ) {
										$element = self::find_element_recursive( $element['elements'], $form_id );

										if ( $element ) {
												return $element;
										}
								}
						}

						return false;
				}

				public function register_controls() {
						$controls_manager = Plugin::elementor()->controls_manager;

						$controls_manager->register_control( Fields_Repeater::CONTROL_TYPE, new Fields_Repeater() );
						$controls_manager->register_control( Fields_Map::CONTROL_TYPE, new Fields_Map() );
				}

				/**
				 * Register submissions
				 */
				private function register_submissions_component() {
					$experiments_manager = Plugin::elementor()->experiments;
					$name = Form_Submissions_Component::NAME;

					$experiments_manager->add_feature( [
						'name' => $name,
						'title' => esc_html__( 'Form Submissions', 'elementor-pro' ),
						'description' => esc_html__( 'Never lose another submission! Using “Actions After Submit” you can now choose to save all submissions to an internal database.', 'elementor-pro' ),
						'release_status' => Manager::RELEASE_STATUS_STABLE,
						'default' => Manager::STATE_ACTIVE,
					] );

					if ( ! $experiments_manager->is_feature_active( $name ) ) {
						return;
					}

					$this->add_component( $name, new Form_Submissions_Component() );
				}


				/**
				 * Module constructor.
				 */
				public function __construct() {
						parent::__construct();

						add_filter( 'elementor_pro/editor/localize_settings', [ $this, 'localize_settings' ] );
						add_action( 'elementor/controls/controls_registered', [ $this, 'register_controls' ] );

						$this->add_component( 'gglcptch', new Elementor_Gglcptch() );

						$this->register_submissions_component();

						// Initialize registrars.
						$this->actions_registrar = new Form_Actions_Registrar();
						$this->fields_registrar = new Form_Fields_Registrar();
						
						// Ajax Handler
						if ( Classes\Ajax_Handler::is_form_submitted() ) {
							$this->add_component( 'ajax_handler', new Classes\Ajax_Handler() );

							/**
							 * Elementor form submitted.
							 *
							 * Fires when the form is submitted. This hook allows developers
							 * to add functionality after form submission.
							 *
							 * @since 2.0.0
							 *
							 * @param Module $this An instance of the form module.
							 */
							do_action( 'elementor_pro/forms/form_submitted', $this );
						}
				}
			}
		} elseif( version_compare( $all_plugins['elementor-pro/elementor-pro.php']['Version'], '3.19.9', '<=' ) ) {
			add_action( 'elementor_pro/forms/register_action', function( Module $module ) {
				$module->add_component( 'gglcptch', new Elementor_Gglcptch() );
			} );
		} else {
			add_action( 'elementor_pro/forms/actions/register', function( $form_actions_registrar ) {
				$form_actions_registrar->register( new Elementor_Gglcptch() );
			} );
		}
	}
}
