<?php

if ( ! class_exists( 'GF_Field_Gglcptch' ) ) {
	class GF_Field_Gglcptch extends GF_Field {

		public $type = 'gglcptch';

		public function get_form_editor_field_title() {
			return 'BWS reCaptcha';
		}

		function get_form_editor_field_settings() {
			return array(
				'conditional_logic_field_setting',
				'label_setting',
				'label_placement_setting',
				'description_setting',
				'css_class_setting'
			);
		}

		public function validate( $value, $form ) {
			$gglcptch_check = gglcptch_check( 'gravity_forms' );
			if ( ! $gglcptch_check['response'] ) {
				$this->failed_validation  = true;
				$this->validation_message = implode( "<br>", $gglcptch_check['errors']->get_error_messages() );
			}
		}

		public function get_form_editor_inline_script_on_page_render() {
			return "gform.addFilter('gform_form_editor_can_field_be_added', function (canFieldBeAdded, type) {
		        if (type == '{$this->type}') {
		            if (GetFieldsByType(['{$this->type}']).length > 0) {
		                alert(" . json_encode( __( 'Only one BWS reCaptcha field can be added to the form', 'google-captcha-pro' ) ) . ");
				 		return false;
		            } else if (GetFieldsByType(['captcha']).length > 0) {
		                alert(" . json_encode( __( 'The form already contains a CAPTCHA, first remove it to add BWS reCaptcha', 'google-captcha-pro' ) ) . ");
						return false;
		            }
		        }
		        return canFieldBeAdded;
		    });";
		}

		public function get_field_input( $form, $value = '', $entry = null ) {
			return gglcptch_display();
		}
	}
}

if ( ! function_exists( 'gglcptch_set_default_value' ) ) {
	function gglcptch_set_default_value() {
		echo 'case "gglcptch" :
			field.label = "BWS reCaptcha";
	    break;';
	}
}

$is_user_logged_in = is_user_logged_in();
if ( gglcptch_is_recaptcha_required( 'gravity_forms', $is_user_logged_in ) ){
	GF_Fields::register( new GF_Field_Gglcptch() );
	add_action( 'gform_editor_js_set_default_values', 'gglcptch_set_default_value' );
}
