<?php

/**
 * BWS Recaptcha for Ultimate Member
 *
 * @since 1.63
 */

if ( ! function_exists( 'gglcptch_core_fields' ) ) {
    function gglcptch_core_fields( $core_fields ) {
        $core_fields['gglcptch'] = array(
            'name' => 'Recaptcha',
            'in_fields' => false,
            'form_only' => true,
        );

        return $core_fields;
    }
}

if ( ! function_exists( 'gglcptch_predefined_fields' ) ) {
    function gglcptch_predefined_fields( $predefined_fields ) {
        $predefined_fields['gglcptch_field'] = array(
            'title' => __( 'BWS reCaptcha', 'google-captcha-pro' ),
            'metakey' => 'gglcptch',
            'type' => 'gglcptch',
            'label' => __( 'BWS reCaptcha', 'google-captcha-pro' )
        );

        return $predefined_fields;
    }
}

if ( ! function_exists( 'gglcptch_output_field_recaptcha' ) ) {
    function gglcptch_output_field_recaptcha ( $output, $set_mode ) {
        $is_user_logged_in = is_user_logged_in();
        if ( isset( $set_mode ) && gglcptch_is_recaptcha_required( "ultimate_member_{$set_mode}", $is_user_logged_in ) ) {
            $output .= gglcptch_display();
            $form_id = UM()->fields()->set_id;
						$text    = '';
						if ( isset( UM()->form()->errors['gglcptch_field'] ) ) {
							$text = UM()->form()->errors['gglcptch_field'];
						}

            if ( isset( $form_id ) && UM()->form()->processing == $form_id && ! empty( $text ) ) {
                $output .= '<div class="um-field-error"><span class="um-field-arrow"><i class="um-faicon-caret-up"></i></span>' . esc_attr( $text ) . '</div>';
            }
        }
        return $output;
    }
}

if ( ! function_exists( 'gglcptch_um_validate_recaptcha' ) ) {
    function gglcptch_um_validate_recaptcha () {
        $form_id = UM()->form()->form_id;
        $form_type = get_post_meta( $form_id, '_um_mode', true );
        $gglcptch_check = gglcptch_check( "ultimate_member_{$form_type}" );

        if ( isset( UM()->form()->post_form['g-recaptcha-response'] ) && ! $gglcptch_check['response'] ) {
            UM()->form()->add_error( 'gglcptch_field', implode( "<br>", $gglcptch_check['errors']->get_error_messages() ) );
            $gglcptch_error = implode( "<br>", $gglcptch_check['errors']->get_error_messages() );
        }
    }
}

/* Ultimate Member */
if ( is_admin() ) {
	if ( isset( $_POST['action'] ) && 'um_dynamic_modal_content' === $_POST['action'] ) {
			$form_type = ! isset( $form_type ) && isset( $_POST['form_mode'] ) ? sanitize_text_field( $_POST['form_mode'] ) : $form_type;
	} else if ( isset( $_POST['action'] ) && 'um_update_builder' === $_POST['action'] ) {
		$form_id = isset( $_POST['form_id'] ) ? intval( $_POST['form_id'] ) : null;
		$form_type = isset( $form_id ) ? get_post_meta( $form_id, '_um_mode', true ) : null;
	} else if ( isset( $_POST['action'] ) && 'um_do_ajax_action' === $_POST['action'] && isset( $_POST['act_id'] ) && 'um_admin_add_field_from_predefined' === $_POST['act_id'] ) {
		$form_id = isset( $_POST['arg2'] ) ? intval( $_POST['arg2'] ) : null;
		$form_type = isset( $form_id ) ? get_post_meta( $form_id, '_um_mode', true ) : null;
	}

	/* Add reCaptcha to Ultimate Member Login/Register Edit Form */
	if ( ! empty( $form_type ) && gglcptch_is_recaptcha_required( "ultimate_member_{$form_type}", false ) ) {
			add_filter( 'um_core_fields_hook', 'gglcptch_core_fields' );
			add_filter( 'um_predefined_fields_hook', 'gglcptch_predefined_fields' ); 
	}
}

add_filter( 'um_gglcptch_field_form_edit_field', 'gglcptch_output_field_recaptcha', 10, 2 );

add_action( 'um_submit_form_errors_hook_login', 'gglcptch_um_validate_recaptcha' );
add_action( 'um_submit_form_errors_hook__registration', 'gglcptch_um_validate_recaptcha' );
add_action( 'um_submit_form_errors_hook__profile', 'gglcptch_um_validate_recaptcha' );
